#!/bin/sh 
# $Id$
INSTOPT=$1
if [ "X$INSTOPT" == "X" ]
then 
    echo "Usage: $0 [ install | update | start | stop | remove ]

    All these operations can be performed only by the root user.

    install   - to install the PAM360 Agent as a service so that it
                gets started automatically during system startup
				and give the agent key to authendicate.

    update -    to update the Agent key and it will start the
		        service automatically.

    start     - to start the PAM360 Agent process.

    stop      - to stop the PAM360 Agent process.

    remove    - to remove a previously installed PAM360 Agent service from
                the system and the PAM360 Agent will no longer be
                started during system startup."
    exit
fi

INIT_DIR=/etc/init.d
rootuser="false"
APP_NAME="pam360agent-service"

uid=`id -u`
if [ ${uid} = 0 ]
then
  rootuser="true"
else
  rootuser="false"
fi

if [ "${rootuser}" == "false" ]
then
 echo " "
 echo "Operation can be performed only by the root user"
 echo " "
 exit 1
fi

doinstall()
{
    dir=`pwd`

    if [ -f $INIT_DIR/$APP_NAME ]
    then
        echo "PAM360 Agent Service already installed !"
    else
        cd /etc/init.d
        ln -sf $dir/$APP_NAME $INIT_DIR/$APP_NAME
        chmod a+x $INIT_DIR/$APP_NAME
        chmod a+x $dir/$APP_NAME
        ln -sf $INIT_DIR/$APP_NAME /etc/rc2.d/S20$APP_NAME
        ln -sf $INIT_DIR/$APP_NAME /etc/rc3.d/S20$APP_NAME
        ln -sf $INIT_DIR/$APP_NAME /etc/rc4.d/S20$APP_NAME
        ln -sf $INIT_DIR/$APP_NAME /etc/rc5.d/S20$APP_NAME

        ln -sf $INIT_DIR/$APP_NAME /etc/rc0.d/K20$APP_NAME
        ln -sf $INIT_DIR/$APP_NAME /etc/rc1.d/K20$APP_NAME
        ln -sf $INIT_DIR/$APP_NAME /etc/rc6.d/K20$APP_NAME

        echo "PAM360 Agent Service installed successfully !"
	cd - >>/dev/null
    fi
}

function douninstall()
{
    dir=`pwd`

    cp /etc/profile $dir/profile.bkup.ui
    cat $dir/profile.bkup.ui | grep -v MonitorActivities > /etc/profile
    rm -rf /var/session/bin


    if [ -f $INIT_DIR/$APP_NAME ]
    then
        rm -f $INIT_DIR/$APP_NAME
        rm -f /etc/rc2.d/S20$APP_NAME
        rm -f /etc/rc3.d/S20$APP_NAME
        rm -f /etc/rc4.d/S20$APP_NAME
        rm -f /etc/rc5.d/S20$APP_NAME

        rm -f /etc/rc0.d/K20$APP_NAME
        rm -f /etc/rc1.d/K20$APP_NAME
        rm -f /etc/rc6.d/K20$APP_NAME


        echo "PAM360  Agent Service uninstalled successfully !"
    else
        echo "PAM360 Agent Service not installed currently"
    fi
}
function startpam() {
	if [ -f /etc/init.d/pam360agent-service ]
	then
		/etc/init.d/pam360agent-service start
	else
		echo "PAM360 Agent not yet installed. Install agent and try again."
	fi
}

installpam()
{
	if [ -f /etc/init.d/pam360agent-service ]
	then
		/etc/init.d/pam360agent-service install $1
	else
		echo "PAM360 Agent not yet installed. Install agent and try again."
	fi

}

reinstallpam()
{
	if [ -f /etc/init.d/pam360agent-service ]
	then
		/etc/init.d/pam360agent-service reinstall $1
	else
		echo "PAM360 Agent not yet installed. Install agent and try again."
	fi

}


stoppam() {
	echo -n "Stopping PAM360 Agent ....  "
	pid=`ps -C  PAM360Agent -o pid | grep -v PID 2>/dev/null`
	if [ "x$pid" != "x" ]; then
		kill -9 $pid 2>/dev/null
		echo "stopped!"
	else
		echo "already stopped!"
	fi
}


if [ "${INSTOPT}" == "remove" ]
then
chmod a+x PAM360Agent
chmod a+x pam360agent-service
stoppam
douninstall
fi

if [ "${INSTOPT}" == "install" ]
then
chmod a+x PAM360Agent
chmod a+x pam360agent-service
stoppam
douninstall
doinstall
installpam $2
startpam
fi

if [ "${INSTOPT}" == "start" ]
then
chmod a+x PAM360Agent
chmod a+x pam360agent-service
startpam
fi

if [ "${INSTOPT}" == "stop" ]
then
chmod a+x PAM360Agent
chmod a+x pam360agent-service
stoppam
fi

if [ "${INSTOPT}" == "update" ]
then
chmod a+x PAM360Agent
chmod a+x pam360agent-service
stoppam
reinstallpam $2
startpam
fi

